# coding: utf-8

from __future__ import unicode_literals

import os

from django_pgaas.hosts import HostManager


def create_profile(name, password, mode, atomic_requests):
    # db_name = os.environ.get('POSTGRES_NAME')
    host_name = name.replace('_', '-')
    hosts_from_yc = [
        {"name": "%s01h.db.yandex.net" % host_name, "options": {"geo": "sas", "type": "postgresql"}},
        {"name": "%s01f.db.yandex.net" % host_name, "options": {"geo": "myt", "type": "postgresql"}},
        {"name": "%s01i.db.yandex.net" % host_name, "options": {"geo": "man", "type": "postgresql"}}
    ]

    manager = HostManager.create_from_yc(hosts_from_yc)
    return {
        'ENGINE': 'django_pgaas.backend',
        'CONN_MAX_AGE': 15 * 60,  # seconds
        'OPTIONS': {
            'target_session_attrs': mode,
            'connect_timeout': 5,
            'sslmode': 'verify-full',
            'sslrootcert': '/etc/ssl/certs/ca-certificates.crt'
        },
        'NAME': name,
        'USER': os.environ['POSTGRES_USER'],
        'PASSWORD': password,
        'HOST': manager.host_string,
        'PORT': 6432,
        'ATOMIC_REQUESTS': atomic_requests,
    }
