# coding: utf-8
from __future__ import unicode_literals


def log_reqans(logger, data, client_action, uuid):
    """
    Log request utterance and answer in one parsable message
    """
    assert 'text' in client_action.payload
    logger.info(
        'uhura_request_answer\tlang=%s\tlat=%.5lf\tlon=%.5lf\tuuid=%s\tquery=%s\tresponse=%s',
        data['context'].lang,
        data['context'].ll.lat,
        data['context'].ll.lon,
        uuid,
        data['speechkit']['Utterance'],
        client_action.payload['text']
    )
