# coding: utf-8
from __future__ import unicode_literals


HTML_ESCAPE_MAPPING = {
  '&': '&amp;',
  '<': '&lt;',
  '>': '&gt;',
  '"': '&#34;',
  "'": '&#39;',
}


def edit_distance(s1, s2):
    m = len(s1)
    n = len(s2)
    distance_matrix = [[0 for x in range(n)] for y in range(m)]
    for i in range(m):
        distance_matrix[i][0] = i + 1
    for j in range(n):
        distance_matrix[0][j] = j + 1

    for j in range(n):
        for i in range(m):
            if s1[i] == s2[j]:
                distance_matrix[i][j] = distance_matrix[i - 1][j - 1]
            else:
                distance_matrix[i][j] = min(
                    distance_matrix[i - 1][j],
                    distance_matrix[i][j - 1],
                    distance_matrix[i - 1][j - 1]
                ) + 1
    return distance_matrix[m - 1][n - 1]


def join_with_max_length(strings, max_length, join_with):
    joined_strings = []
    cur_strings = []
    cur_len = 0
    for string in strings:
        if cur_len + len(string) + 1 < max_length:
            cur_len += len(string)
            cur_strings.append(string)
        else:
            joined_strings.append(join_with.join(cur_strings))
            cur_strings = []
    if cur_strings:
        joined_strings.append(join_with.join(cur_strings))
    return joined_strings


def unescape_html(s):
    for (k, v) in HTML_ESCAPE_MAPPING.iteritems():
        s = s.replace(v, k)
    return s
