from django.conf import settings
from django.utils.functional import SimpleLazyObject

from tvm2 import TVM2
from tvm2.exceptions import TVM2BaseException


class NotAllTicketsException(TVM2BaseException):
    pass


_TVM = SimpleLazyObject(
    lambda: TVM2(
        client_id=settings.TVM2_UHURA_ID,
        secret=settings.UHURA_TVM2_SECRET,
        blackbox_client=settings.INTERNAL_BLACKBOX_CLIENT,
    )
)


def get_tvm_service_ticket(tvm2_service_id):
    service_tickets = _TVM.get_service_tickets(str(tvm2_service_id))
    ticket = service_tickets.get(str(tvm2_service_id))
    return ticket


def get_tvm_service_headers(tvm2_service_id):
    ticket = get_tvm_service_ticket(tvm2_service_id)

    if ticket is not None:
        return {'X-Ya-Service-Ticket': ticket}
    else:
        raise NotAllTicketsException()


def get_tvm_user_ticket(oauth_token):
    return _TVM.get_user_ticket(
        user_ip='127.0.0.1',
        server_host=None,
        oauth_token=oauth_token,
    )


def get_tvm_user_headers(oauth_token):
    ticket = get_tvm_user_ticket(oauth_token)

    if ticket is not None:
        return {'X-Ya-User-Ticket': ticket}
    else:
        raise NotAllTicketsException()
