import sys
import os
import json
import yaml


def to_yaml(path):
    with open(path) as inp:
        data = json.load(inp)

    yaml_path = os.path.splitext(path)[0] + ".yaml"

    with open(yaml_path, 'w') as outfile:
        yaml.safe_dump(data, outfile, default_flow_style=False, encoding='utf-8', allow_unicode=True)

    os.remove(path)


def patch_json(node, root_dir):
    if isinstance(node, dict):
        for key, item in node.items():
            patch_json(item, root_dir)
            if isinstance(item, basestring):
                if item.endswith(".json"):
                    to_yaml(os.path.join(root_dir, item))
                    node[key] = os.path.splitext(item)[0] + ".yaml"

    elif isinstance(node, list):
        for item in node:
            patch_json(item, root_dir)


for root, dirs, files in os.walk("."):
    for f in files:
        if f == 'VinsProjectfile.json' and root != '.':
            path = os.path.join(root, f)
            data = json.loads(open(path).read())
            patch_json(data, root)
            json.dump(data, open(os.path.join(root,f), 'w'), indent=4)

            to_yaml(path)

        if f == 'Vinsfile.json':
            path = os.path.join(root, f)
            to_yaml(path)
