import os
import json
import copy

data = json.loads(open('VinsProjectfile.json').read())
data_vinsfile = json.loads(open('../Vinsfile.json').read())
data_vinsfile['project']['includes'] = []


def patch_json(node, prefix):
    if isinstance(node, dict):
        for key, item in node.items():
            patch_json(item, prefix)
            if isinstance(item, basestring):
                if item.startswith(prefix):
                    node[key] = item[len(prefix):]

    elif isinstance(node, list):
        for item in node:
            patch_json(item, prefix)


def _get_category(item):
    pp = item['dm']['path']
    return pp.split('/')[1]


mm = {}
for item in data['intents']:
    categ = _get_category(item)
    if categ not in mm:
        mm[categ] = []
    mm[categ].append(item)

for categ, intents in mm.iteritems():
    filename = os.path.join('intents', categ, 'VinsProjectfile.json')
    dd = copy.deepcopy(data)
    dd['intents'] = intents
    dd['microintents'] = []
    dd['entities'] = []
    dd['name'] = categ
    patch_json(dd, 'intents/' + categ + '/')
    open(filename, 'w').write(json.dumps(dd, indent=4))
    data_vinsfile['project']['includes'].append({'path': "/app/uhura/vins_project/" + filename, 'type': 'file'})

filename = 'microintents/VinsProjectfile.json'
dd = copy.deepcopy(data)
dd['intents'] = []
dd['entities'] = []
dd['name'] = 'microintents'
patch_json(dd, 'microintents/')
open(filename, 'w').write(json.dumps(dd, indent=4))
data_vinsfile['project']['includes'].append({'path': "/app/uhura/vins_project/" + filename, 'type': 'file'})

filename = 'entities/VinsProjectfile.json'
dd = copy.deepcopy(data)
dd['intents'] = []
dd['microintents'] = []
dd['name'] = 'entities'
patch_json(dd, 'entities/')
open(filename, 'w').write(json.dumps(dd, indent=4))
data_vinsfile['project']['includes'].append({'path': "/app/uhura/vins_project/" + filename, 'type': 'file'})

open("../Vinsfile.json", 'w').write(json.dumps(data_vinsfile, indent=4))
