package ru.yandex.galois.clients.abc.model

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonProperty
import java.time.Instant

@JsonIgnoreProperties(ignoreUnknown = true)
data class AbcServiceMember(val id: Long,
    val person: AbcPersonRef,
    val service: AbcServiceRef,
    val role: AbcRoleRef,
    @JsonProperty("created_at")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss[.SSSSSS]XXX", timezone = "UTC")
    val createdAt: Instant,
    @JsonProperty("modified_at")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss[.SSSSSS]XXX", timezone = "UTC")
    val modifiedAt: Instant)
