package ru.yandex.galois.clients.staff.model

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonProperty
import java.time.Instant

@JsonIgnoreProperties(ignoreUnknown = true)
data class StaffGroupMembership(val id: Long,
    val group: StaffGroup,
    @JsonProperty("_meta")
    val meta: StaffMeta,
    val person: StaffPersonRef,
    @JsonProperty("joined_at")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss[.SSSSSS]XXX", timezone = "UTC")
    val joinedAt: Instant
)
