from collections import namedtuple

import yenv

from django.conf import settings

from intranet.vconf.src.call.models import ConferenceCall


class AllStreamersAreBusy(Exception):
    pass


EtherId = namedtuple('EtherId', ['back_id', 'front_id'])

ETHER_IDS = [
    EtherId('int_vconf2', '419617aaa605bff68a6e907ed016b3e5'),
    EtherId('int_vconf3', '468bc0cd94defad582023e94677ba008'),
    EtherId('int_vconf4', '4659b7e84376bc0291a13629189dcf71'),
    EtherId('int_vconf5', '4287cf8a69e356ceb1c4ec9cf7eb8f09'),
    EtherId('int_vconf6', '428f251e617a584082eacc17fb53a1e6'),
    EtherId('int_vconf7', '4d56c2fc5971155f99963deeb0ee83a4'),
    EtherId('int_vconf8', '4fb009aef74e7850a8b41576ae323d54'),
    EtherId('int_vconf9', '493bd40ab6c51af5917c05e3536bd41b'),
    EtherId('int_vconf10', '4a9a7ea252e29edd8f33114a177da238'),
    EtherId('int_vconf11', '4545f4a94bfbf34d86ab544d7ff7c9fe'),
    EtherId('int_vconf12', '41bf693eeb4da83ab3a4f6584e581b5f'),
    EtherId('int_vconf13', '41a41dd15d87392bb5b63ef2dbbf0e56'),
    EtherId('int_vconf14', '4eb1af5520263251af1ae67e62dfc29b'),
    EtherId('int_vconf15', '4ddc47d4b31685a7a7df5353d66fc6d8'),
    EtherId('int_vconf16', 'f6fa8fd91e95af8a1f11851722f40aa'),
    EtherId('int_vconf17', '43cf69f2e47e83c7b3ce47514f8167d3'),
    EtherId('int_vconf18', '4e9e6883edaec2aea609713e0b11ed7e'),
    EtherId('int_vconf19', '4c6bfad3a288b73e8041b0a27f0fdd6e'),
    EtherId('int_vconf20', '49d33bf1c98c7455bb0c80629f52f53d'),
    # VCONF-886 - уменьшаем количество каналов до 20
    # EtherId('int_vconf21', '435b41c5405d437f8534d8ad89768935'),
    # EtherId('int_vconf22', '44e0cd83686e1e71a45688831ac9d0b1'),
    # EtherId('int_vconf23', '405430c1939f9fd9a0c3cc1ec5fcc5af'),
    # EtherId('int_vconf24', '4195e24b8b9f477b863fa3c80728f651'),
    # EtherId('int_vconf25', '4e3ed1fa6696833eb12212a43c08a67e'),
    # EtherId('int_vconf26', '4490f893728b1c06852c7b52f924e239'),
    # EtherId('int_vconf27', '4fca10222cb4b587a1f5ea1e1a7dcd43'),
    # EtherId('int_vconf28', '4caf322ea8aab79aaf6a8fa7d7d91696'),
    # EtherId('int_vconf29', '4a3fb6fd1bc917b894442774601d7d7b'),
    # EtherId('int_vconf30', '4ac41cfccf59092590bc2fff0a2e63d6'),
    # EtherId('int_vconf31', '48d76fc13ae2ca739a56e138083352de'),
    # EtherId('int_vconf32', '45c1637bbc95f36699fc5f8e3866e3c0'),
    # EtherId('int_vconf33', '4c65e291fbfca2b4bed2e0b39ca4aac2'),
    # EtherId('int_vconf34', '4f80db8c845ff4fdb46617d31b639e23'),
    # EtherId('int_vconf35', '4d1bc0492743e53d873e732c7ba65690'),
    # EtherId('int_vconf36', '4fd0ca9ceec61bfea1338657d368eaf7'),
    # EtherId('int_vconf37', '40a152d0844b4c3a90cec5d51b1880b4'),
    # EtherId('int_vconf38', '4cbf826802fa2e43abfd2a63ef7ca33c'),
    # EtherId('int_vconf39', '4e74bd1d51bbefe4b39dc8a2d2fb4159'),
    # EtherId('int_vconf40', '48161c2525f6aab8a4cd5856ead23c54'),
    # EtherId('int_vconf41', '4f2eebe6415ffa12927edd3a9f3c576f'),
    # EtherId('int_vconf42', '45467a9ec273f159ba0b5f2b8a305a55'),
    # EtherId('int_vconf43', '4b6ee4ee2d502f3593cabea5b48ca761'),
    # EtherId('int_vconf44', '40d8ac20d732559f88796034a23a827d'),
    # EtherId('int_vconf45', '402039103180b9599fd5972b09e9a729'),
    # EtherId('int_vconf46', '42c1928b3a4df30d9e8f30cd143376cc'),
    # EtherId('int_vconf47', '4f141c9a1ab84e1ba9ef1cfafb9a0f5f'),
    # EtherId('int_vconf48', '40721f746027eb62b63495ffb23cb3d5'),
    # EtherId('int_vconf49', '468c6db4fde847bdaee5e2140e5a1ba8'),
    # EtherId('int_vconf50', '4e605cf4f871c9bebbb032f2f288a9fa'),
]

if yenv.type != 'production':
    ETHER_IDS = [
        EtherId('vconf_test1', '43d7ed4283f8e794b7156b93767effce'),
    ]
    for i in range(1, 20):
        ETHER_IDS.append(EtherId(f'test{i}', 'test'))


HURAL_ETHER_ID = EtherId('int_bluewhale', '426415ce497db10e83cc27fc292f6f1d')


def get_ether_id(call: ConferenceCall) -> EtherId:
    if call.template_id == settings.HURAL_TEMPLATE_ID:
        return HURAL_ETHER_ID

    used_ids = {EtherId(*v) for v in (
        ConferenceCall.objects
        .filter(state=ConferenceCall.STATES.active)
        .values_list('ether_back_id', 'ether_front_id')
    )}

    for eid in ETHER_IDS:
        if eid not in used_ids:
            return eid

    raise AllStreamersAreBusy
