import logging

from django.utils import timezone
from django.core.management.base import BaseCommand

from intranet.vconf.src.ext_api.messenger import MessengerAPI
from intranet.vconf.src.call.models import ConferenceCall

log = logging.getLogger(__name__)


class Command(BaseCommand):
    help = 'Stop chat for ended calls'

    def handle(self, *args, **options):
        now = timezone.now()
        one_hour_ago = now - timezone.timedelta(hours=1)

        calls = ConferenceCall.objects.filter(stop_time__lte=one_hour_ago, has_active_chat=True)
        for call in calls:
            try:
                MessengerAPI.stop_chat(call.chat_id)
                log.info('Chat %s for call %s was stopped', call.chat_id, call.conf_cms_id)
            except Exception:
                log.exception(
                    'Error when auto stop chat %s for call %s', call.chat_id, call.conf_cms_id
                )
            else:
                call.has_active_chat = False
                call.save()
