import logging

from django.conf import settings
from django.contrib.auth import get_user_model
from django.core.management.base import BaseCommand
from intranet.vconf.src.call.manager import CallManager


log = logging.getLogger(__name__)
User = get_user_model()


class Command(BaseCommand):
    help = 'Stop outdated or broken calls '

    def handle(self, *args, **options):
        robot = User.objects.get(username=settings.VCONF_ROBOT_LOGIN)
        for call in CallManager.find_outdated(for_user=robot):
            try:
                call.stop()
                log.info('Call %s was out date and stoped', call.obj.conf_cms_id)
            except Exception:
                log.exception(
                    'Error when auto stop call %s', call.obj.conf_cms_id
                )
