import logging

from django.core.management.base import BaseCommand

from intranet.vconf.src.call.models import CallTemplate
from intranet.vconf.src.call.call_template import Template
from intranet.vconf.src.ext_api.calendar import get_event_info, CalendarError

log = logging.getLogger(__name__)


class Command(BaseCommand):
    help = 'Sync events from templates'

    def handle(self, *args, **options):
        templates = (
            CallTemplate.objects
            .filter(next_event__isnull=False, stream=True)
            .select_related('next_event')
        )

        for template in templates:
            template_manager = Template(obj=template)
            try:
                event_data = get_event_info(event_id=template.next_event_id)
            except CalendarError:
                log.exception('Error during syncing event %s', template.next_event_id)
                continue

            event_data['master_id'] = template.next_event_id
            template_manager.update_event(event_data)
