import logging

from django.core.management.base import BaseCommand
from django.utils import timezone
from intranet.vconf.src.call.models import Node
from intranet.vconf.src.ext_api.cms import CMSApi


log = logging.getLogger(__name__)


class Command(BaseCommand):
    help = 'Update node system load values'

    def handle(self, *args, **options):
        nodes = Node.objects.filter(enabled=True)
        for node in nodes:
            cms = CMSApi(node=node.api_url)
            try:
                load_value = cms.system_load()
            except Exception:
                log.exception('Error during get system load from CMS API for node %s', node.id)
            else:
                node.load_value = load_value
                node.last_update = timezone.now()
                node.save()
