import logging

from ylog.context import log_context

from django.core.management.base import BaseCommand
from django.conf import settings

from intranet.vconf.src.call.manager import ConferenceCall
from intranet.vconf.src.call.models import CALL_STATES
from intranet.vconf.src.ext_api.xiva import get_viewers_count, send_viewers_count

log = logging.getLogger(__name__)


class Command(BaseCommand):
    help = 'Update streams viewers count'

    def handle(self, *args, **options):
        if not settings.COUNT_STREAM_VIEWERS:
            return

        streams = ConferenceCall.objects.filter(stream=True, state=CALL_STATES.active)
        for stream in streams:
            stream_id = stream.ether_back_id
            count = get_viewers_count(topic=stream_id)
            if count is not None:
                with log_context(stream_name=stream.name):
                    log.info('Stream %s has %s viewers', stream.name, count)
                stream.viewers_count = count
                stream.save()
                send_viewers_count(topic=stream.ether_back_id, count=count)
