# Generated by Django 2.0.7 on 2018-07-27 15:20

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ConferenceCall',
            fields=[
                ('conf_cms_id', models.CharField(max_length=64, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=64)),
                ('call_cms_id', models.CharField(default='', max_length=64)),
                ('meeting_id', models.CharField(max_length=64)),
                ('start_time', models.DateTimeField(null=True)),
                ('duration', models.DurationField()),
                ('stream', models.BooleanField(default=False)),
                ('record', models.BooleanField(default=False)),
                ('author_login', models.CharField(max_length=128)),
                ('state', models.CharField(choices=[('broken', 'broken'), ('active', 'active'), ('ended', 'ended')], default='broken', max_length=32)),
            ],
        ),
        migrations.CreateModel(
            name='Participant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cms_id', models.CharField(max_length=64)),
                ('is_active', models.BooleanField(default=False)),
                ('state', models.CharField(choices=[('active', 'active'), ('disconnected', 'disconnected'), ('ended', 'ended')], default='disconnected', max_length=32)),
                ('obj_id', models.CharField(max_length=64)),
                ('obj_type', models.CharField(max_length=64)),
                ('number', models.CharField(max_length=64)),
                ('camera', models.BooleanField(default=True)),
                ('microphone', models.BooleanField(default=True)),
                ('method', models.CharField(choices=[('cisco', 'cisco'), ('email', 'email'), ('mobile', 'mobile')], default='cisco', max_length=32)),
                ('name', models.CharField(max_length=128)),
                ('conf_call', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='call.ConferenceCall')),
            ],
        ),
        migrations.CreateModel(
            name='Record',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('node', models.CharField(max_length=64)),
                ('file_name', models.CharField(max_length=64)),
                ('conf_call', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='call.ConferenceCall')),
            ],
        ),
    ]
