from django.db import migrations, models
from django.utils import timezone


def create_nodes(apps, schema_editor):
    Node = apps.get_model('call', 'Node')
    now = timezone.now()
    load_limits = {
        1: 96000,
        2: 96000,
        3: 96000,
        4: 57500,
        5: 32500,
        6: 37500,
        7: 37500,
        8: 37500,
        9: 32500,
        10: 37500,
        11: 37500,
        12: 37500,
        13: 37500,
        14: 37500,
        15: 32500,
    }
    vm_host_parts = {
        1: 'myt-vm15',
        2: 'kr-vm10',
        3: 'sas-vm6',
        4: 'myt-vm2',
        5: 'kr-vm11',
        6: 'sas-vm8',
        7: 'mar-vm3',
        8: 'iva-vm8',
        9: 'kr-vm12',
        10: 'avex-vm2',
        11: 'std-vm1',
        12: 'mar-vm4',
        13: 'myt-vm18',
        14: 'myt-vm19',
        15: 'avex-vm3',
    }
    for node_id in load_limits.keys():
        Node.objects.create(
            id=node_id,
            vm_host='cipt-{}.yndx.net'.format(vm_host_parts[node_id]),
            last_update=now,
            load_value=0,
            load_limit=load_limits[node_id],
            enabled=True,
        )


def delete_nodes(apps, schema_editor):
    Node = apps.get_model('call', 'Node')
    Node.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('call', '0021_stream_picture_field'),
    ]

    operations = [
        migrations.CreateModel(
            name='Node',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('vm_host', models.CharField(max_length=32, default='', blank=True)),
                ('last_update', models.DateTimeField()),
                ('load_value', models.IntegerField()),
                ('load_limit', models.IntegerField()),
                ('enabled', models.BooleanField(default=False)),
            ],
        ),
        migrations.RunPython(
            code=create_nodes,
            reverse_code=delete_nodes,
        ),
    ]
