import logging
import random
from intranet.vconf.src.ext_api.staff import get_whistlah_data_by_login
from intranet.vconf.src.lib.cache import memoize


DEFAULT_CODE = 'default'
DEFAULT_RTLRS = ['cipt-rtlr-{0:0>3}'.format(i) for i in (5, 7, 8, 9, 10, 11, 12, 13)]
KR_RTLRS = ['cipt-rtlr-{0:0>3}'.format(i) for i in (1, 2, 3, 6)]
YAMONEY_RTLR = 'mirror-stream.yamoney.ru'


# TODO: Попробовать автоматизировать по городам офисов
OFFICE_TO_RTLRS = {
    "almaty": ['barbel', 'snakehead'],  # Алматы, БЦ Достык
    "freshlaza": ['anchovy', 'saury'],  # Владивосток, БЦ Fresh Plaza
    "vl": ['luce', 'minnow'],  # Датацентр «Владимир»
    "vrnzh": ['vobla', 'whitefish'],  # Воронеж, БЦ Галеон
    "eburg": ['chebak', 'plotva'],  # Екатеринбург, БЦ Палладиум
    "ivanteevka": ['roach', 'sazan'],  # Датацентр «Ивантеевка»
    "israel": ['cipt-rtlr-004'],  # Израиль, Тель-Авив
    "Innopolis": ['lamprey', 'puffer'],  # Казань, Иннополис
    "kzn": ['sopa', 'zhereh'],  # Казань, БЦ Сувар-Плаза
    "admiral": ['searobin', 'spot'],  # Краснодар, БЦ Адмирал
    "balans": ['knerii', 'tugun'],  # Красноярск, БЦ Баланс
    "minsk": ['lin', 'nalim'],  # Минск, БЦ RubinPlaza
    "avrora": DEFAULT_RTLRS,  # Москва, БЦ Аврора
    'rrm': DEFAULT_RTLRS,  # Москва, БЦ Мамонтов
    "redrose": KR_RTLRS,  # Москва, БЦ Морозов
    'kr': KR_RTLRS,  # Москва, Красная роза Wi-Fi
    "zb": ['bullhead', 'misgurnus'],  # Москва, БЦ Зубовский
    "rrs": DEFAULT_RTLRS,  # Москва, БЦ Строганов
    "mytishi": ['bream', 'perch'],  # Датацентр «Мытищи»
    "helsinki": ['salmon', 'trout'],  # Датацентр Мянтсяля
    "nether": ['cipt-rtlr-004'],  # Нидерланды, Амстердам
    "nnlob": ['chehon', 'gustera'],  # Нижний Новгород, БЦ Лобачевский Plaza
    "techpark": ['osetr', 'taimen'],  # Новосибирск, Академпарк
    "nsk": ['muksun', 'nelma'],  # Новосибирск, БЦ Гринвич
    "rnd": ['golavl', 'sudak'],  # Ростов-на-Дону, БЦ Пять морей
    "rfc": ['percarina', 'zope'],  # Ростов-на-Дону, Фулфилмент-центр
    "spb": ['kambala', 'korushka', 'treska'],  # Санкт-Петербург, БЦ Бенуа
    "peterplaza": ['dace', 'palia'],  # Санкт-Петербург, БЦ Ренессанс Плаза
    "sasovo": ['karp', 'ukleika'],  # Датацентр «Сасово»
    "simf": ['tulka', 'harius'],  # Симферополь
    "sfc": ['capelin', 'stingray'],  # Софьино, Фулфилмент центр
    "sochi": ['scomber', 'sprat'],  # Сочи, Адлер
    "usa": ['porgy', 'tuna'],  # США, Ньюберипорт
    "turk": ['balik', 'somon'],  # Турция, Стамбул
    "tfc": ['wahoo', 'wolffish'],  # Томилино, Фулфилмент центр
    "ta": ['croaker', 'umbra'],  # Тюмень, БЦ Альянс
    "uap": ['eel', 'pipefish'],  # Уфа, БЦ Александровский пассаж
    "chel": ['buffalo', 'lavaret'],  # Челябинск, БЦ Бовид
    DEFAULT_CODE: DEFAULT_RTLRS,
}


@memoize(60 * 60)  # hour
def get_office_code(login):
    data = get_whistlah_data_by_login(login)
    # whistlah ручка отдает все как строки
    if data['is_vpn'] == 'True':
        return DEFAULT_CODE
    return data['office']['code']


def get_retranslator_host(user):
    if user.affiliation == 'yamoney':
        return YAMONEY_RTLR

    try:
        office_code = get_office_code(user.login)
    except Exception:
        logging.exception('Cannot get data from whistlah for `%s`', user.login)
        office_code = DEFAULT_CODE

    if office_code not in OFFICE_TO_RTLRS:
        office_code = DEFAULT_CODE

    rtlrs = OFFICE_TO_RTLRS[office_code]
    return random.choice(rtlrs) + '.rtlr.yandex.net'


def get_ether_url(call):
    return 'https://frontend.vh.yandex.ru/player/%s?from=vconf' % call.ether_front_id
