from django.urls import path

from intranet.vconf.src.call.views import calls as call_views
from intranet.vconf.src.call.views import templates as template_views
from intranet.vconf.src.call.views import events as event_views


urlpatterns = [
    # call
    path('participants/current/', call_views.current_user, name='current_user'),
    path('participants/current/settings', call_views.user_settings, name='user_settings'),
    path('participants/', call_views.meta, name='participants'),
    path('calls/meta/', call_views.meta, name='meta'),
    path('calls/create/', call_views.call_create, name='create'),
    path('calls/create/meta/', call_views.call_create_meta, name='create_meta'),
    path('calls/', call_views.call_list, name='call_list'),
    path('calls/<uuid:conf_cms_id>/', call_views.call_detail, name='call_detail'),
    path('calls/<uuid:conf_cms_id>/add/', call_views.add_participant, name='add_participant'),
    path('calls/<uuid:conf_cms_id>/remove/', call_views.remove_participant, name='remove_participant'),
    path('calls/<uuid:conf_cms_id>/disconnect/', call_views.disconnect_participant, name='disconnect_participant'),
    path('calls/<uuid:conf_cms_id>/toggle_camera/', call_views.toggle_camera, name='toggle_camera'),
    path('calls/<uuid:conf_cms_id>/toggle_microphone/', call_views.toggle_microphone, name='toggle_microphone'),
    path('calls/<uuid:conf_cms_id>/duration/', call_views.call_duration, name='call_duration'),
    path('calls/<uuid:conf_cms_id>/stop/', call_views.call_stop, name='call_stop'),
    path('calls/<uuid:conf_cms_id>/record/', call_views.delete_record, name='delete_record'),
    # templates
    path('templates/create/', template_views.save_template, name='create_template'),
    path('templates/', template_views.template_list, name='template_list'),
    path('templates/<int:obj_id>/', template_views.save_template, name='template_detail'),
    path('templates/<int:obj_id>/delete/', template_views.delete_template, name='delete_template'),
    path('templates/<int:obj_id>/stream/', template_views.template_stream, name='template_stream'),
    path('templates/streams', template_views.templates_with_stream, name='templates_with_stream'),
    # events
    path('events/', event_views.event_list, name='event_list'),
    path('events/<int:event_id>/', event_views.event_detail, name='event_detail'),
    path('events/<int:event_id>/generate_secret/', event_views.event_generate_secret, name='event_generate_secret'),
    path('events/<int:event_id>/invite/', event_views.event_invite, name='event_invite'),
]
