import json
from django.db.models import Count, Q
from django.http import HttpResponse

from intranet.vconf.src.call.models import ConferenceCall, Participant


def active_calls_signals():
    """
    Статистика по активным участникам звонка: абсолютное количество и данные для гистограммы
    """
    active_participants_count = Count(
        expression='participants',
        filter=Q(participants__state=Participant.STATES.active)
    )
    active_calls = (
        ConferenceCall.objects
        .filter(state=ConferenceCall.STATES.active)
        .annotate(active_participants_count=active_participants_count)
        .values('stream', 'active_participants_count', 'viewers_count')
    )
    active_participants = sorted(call['active_participants_count'] for call in active_calls)
    active_streams = [a for a in active_calls if a['stream']]
    viewers_count = sum([call['viewers_count'] for call in active_streams])

    return [
        [f'active_calls_axxx', len(active_calls)],
        [f'active_streams_axxx', len(active_streams)],
        [f'active_stream_viewers_axxx', viewers_count],
        [f'active_participants_axxx', sum(active_participants)],
        [f'active_participants_hist_ahhh', active_participants],
    ]


def unistat(request):
    """
    Выдача статистики для отрисовки графиков в yasm.
    Подробнее: https://wiki.yandex-team.ru/golovan/userdocs/stat-handle/
    """
    data = active_calls_signals()
    return HttpResponse(json.dumps(data))
