import logging

from intranet.vconf.src.call.models import Participant, ConferenceCall, PARTICIPANT_TYPES
from intranet.vconf.src.call.participant_ctl import ParticipantCtl, CallManager

log = logging.getLogger(__name__)


def join_participant(call_id, participant_cms_id, name):
    try:
        call = CallManager.get_by_id(call_cms_id=call_id)
    except ConferenceCall.DoesNotExist:
        log.error("Can't find call with id %s", call_id)
        return

    controller = ParticipantCtl(data={
        'method': Participant.METHODS.cms,
        'cms_id': participant_cms_id,
        'type': PARTICIPANT_TYPES.cms,
        'number': name,
        'id': name,
    })

    controller.get_or_create_obj(call.obj, state=Participant.STATES.active)
    log.info('Participant joined %s', controller.data)
