from django.http import HttpResponse
import xmltodict
import logging
from intranet.vconf.src.cdr.actions import join_participant

log = logging.getLogger(__name__)


def is_valid_participant(call_leg):
    """
    для записи и трансляции cisco создаёт отдельный callLeg
    """
    if call_leg['displayName'] == 'recording' and call_leg.get('recording'):
        return False
    if call_leg['displayName'] == 'streaming' and call_leg.get('streaming'):
        return False

    return True


def process_record(record):
    if record['@type'] == 'callLegStart':
        call_leg = record['callLeg']
        if call_leg['type'] == 'acano' and is_valid_participant(call_leg):
            name = call_leg['displayName']
            p_cms_id = call_leg['@id']
            call_id = call_leg['call']
            join_participant(call_id=call_id, participant_cms_id=p_cms_id, name=name)


def process_xml_input(xml):
    data = xmltodict.parse(xml)
    if isinstance(data['records']['record'], list):
        for record in data['records']['record']:
            process_record(record)
    else:
        process_record(data['records']['record'])


def cdr_view(request):
    process_xml_input(request.body.decode('utf-8'))
    return HttpResponse(status=200)
