class Event:
    """
    Событие для подписки
    """
    resource_type = None
    elements = None

    def __init__(self, index):
        self.index = index

    def as_dict(self):
        return {
            'index': self.index,
            'type': self.resource_type,
            'elements': list(self.elements),
        }


class CallsEvent(Event):

    resource_type = 'calls'
    elements = (
        'name',
        'participants',
        'callCorrelator',
    )


class CallRosterEvent(Event):

    resource_type = 'callRoster'
    elements = (
        'name',
        'uri',
        'state',
        'audioMuted',
        'videoMuted',
    )

    def __init__(self, index, call_id):
        super().__init__(index)
        self.call_id = call_id

    def as_dict(self):
        result = super().as_dict()
        result['call'] = self.call_id
        return result
