import logging

from django.conf import settings

from intranet.vconf.src.lib.requests import Session

log = logging.getLogger(__name__)
api_hd_session = Session()
api_hd_session.headers.update({
    'Authorization': f'OAuth {settings.VCONF_ROBOT_TOKEN}',
    'User-agent': 'vconf'
})


def get_passcode_by_id(conf_id):
    url = f'https://api.hd.yandex-team.ru/api/v1/zoom/meetings/{conf_id}'
    try:
        response = api_hd_session.request(
            'GET',
            url,
            verify=False,
            timeout=(0.5, 1, 5, 10),
        )
        res = response.json()
        return res.get('password')
    except Exception as e:
        logging.exception('%s for meeting id %s', e, conf_id)
        return None
