from django.conf import settings
from intranet.vconf.src.lib.requests import Session

staff_session = Session()
staff_session.headers.update({
    'Authorization': 'OAuth %s' % settings.VCONF_ROBOT_TOKEN,
    'User-agent': 'vconf'
})


def get_from_staff_api(path, params):
    response = staff_session.get(
        url=settings.STAFF_API_URL + path,
        params=params,
        timeout=(0.5, 1, 10),
    )
    response.raise_for_status()
    response = response.json()

    return response


def _get_room_info(field_name, values):
    return get_from_staff_api(
        path='/rooms',
        params={
            field_name: ','.join(values),
            '_fields': ','.join([
                'id',
                'phone',
                'equipment.video_conferencing',
                'name',
            ])
        }
    )


def get_room_info(ids):
    return _get_room_info('id', ids)


def get_room_info_by_slugs(slugs):
    return _get_room_info('name.exchange', slugs)


def get_person_info(logins):
    return get_from_staff_api(
        path='/persons/',
        params={
            'login': ','.join(l.lower() for l in logins),
            '_limit': 10000,
            '_fields': ','.join([
                'login',
                'work_phone',
                'work_email',
                'phones',
                'name.last,name.first',
                'environment.timezone',
                'official.affiliation',
            ]),
        }
    )


def get_all_rooms():
    return get_from_staff_api(
        path='/rooms/',
        params={
            'type': 'conference',
            '_fields': ','.join([
                'id',
                'name.display',
                'name.exchange',
                'floor.office.id',
                'floor.office.timezone',
                'floor.office.city.country.code',
                'equipment.video_conferencing',
            ]),
            '_limit': 10000,
        }
    )


# TODO: Не получается сходить со STAFF_TOKEN, Стафф отдает 403
def get_whistlah_data_by_login(login):
    url = '{base_url}/whistlah/where/{login}'.format(base_url=settings.STAFF_URL, login=login)
    response = staff_session.get(
        url=url,
        timeout=(0.5, 1, 5),
    )
    response.raise_for_status()
    response = response.json()
    return response


def is_ip_internal(ip: str) -> bool:
    response = staff_session.get(
        url=f'{settings.AUTH_CHECKER_URL}/network_is_allowed',
        params={'ip': ip},
        timeout=(0.5, 1, 10),
    )
    response.raise_for_status()
    json_response = response.json()
    return json_response['is_internal']
