import logging
from functools import partial

from django.conf import settings

from intranet.vconf.src.lib.requests import Session

log = logging.getLogger(__name__)
player_session = Session()
player_session.headers.update({
    'Authorization': settings.VCONF_ROBOT_TOKEN,
    'User-agent': 'vconf'
})


def stream(stream_name, handle):
    url = 'https://player.yandex-team.ru{}'.format(handle)
    payload = {
        'name': stream_name,
        'description': '{}_stream'.format(stream_name),
    }

    response = player_session.request(
        method='POST',
        url=url,
        json=payload,
        verify=False,
        timeout=(0.5, 1, 5),
    )
    log.debug('Response from player: %s %s', response.status_code, response.text)
    return response


start_stream = partial(stream, handle='/stream_start/')
stop_stream = partial(stream, handle='/stream_end/')
