import logging
import requests

from django.conf import settings

logger = logging.getLogger(__name__)


def replace_underscores(string):
    return string.replace('_', '-')


def get_subscriptions(topic):
    response = requests.get(
        url=settings.XIVA_URL + 'list',
        params={
            'service': 'vconf',
            'topic': replace_underscores(topic),
        },
        headers={
            'Authorization': 'Xiva {}'.format(settings.XIVA_LISTEN_TOKEN),
        },
    )

    response.raise_for_status()
    return response.json()


def get_viewers_count(topic):
    try:
        subscriptions = get_subscriptions(topic)
    except requests.exceptions.RequestException:
        logger.exception('xiva /list error')
        return None

    sessions = {s['session'] for s in subscriptions}
    return len(sessions)


def send_viewers_count(topic, count):
    response = requests.post(
        url=settings.XIVA_URL + 'send',
        params={
            'topic': replace_underscores(topic),
            'event': 'viewers_count',
        },
        headers={
            'Authorization': 'Xiva {}'.format(settings.XIVA_SEND_TOKEN),
            'X-DeliveryMode': 'direct',
        },
        json={'payload': str(count)},
    )

    response.raise_for_status()
    return response.json()
