from hashlib import sha1

from django.core.cache import cache


def memoize(timeout=60):

    def inner(f):
        def x(*args, **kwargs):
            a = str(f.__module__) + str(f.__name__) + str(args) + str(kwargs)
            key = sha1(a.encode('utf-8')).hexdigest()
            result = cache.get(key)
            if not result:
                result = f(*args, **kwargs)
                cache.set(key, result, timeout)
            return result
        return x

    return inner
