from django.conf import settings
from tvm2 import TVM2
from tvmauth import BlackboxTvmId as BlackboxClientId


def get_tvm_client():
    return TVM2(
        client_id=settings.TVM_CLIENT_ID,
        secret=settings.TVM_SECRET,
        blackbox_client=BlackboxClientId.ProdYateam,
        destinations=settings.YAUTH_TVM2_ALLOWED_CLIENT_IDS,
        allowed_clients=settings.YAUTH_TVM2_ALLOWED_CLIENT_IDS,
    )


def get_service_ticket(client_id):
    client_id = str(client_id)
    tvm_client = get_tvm_client()
    service_tickets = tvm_client.get_service_tickets(client_id)
    if client_id in service_tickets:
        return service_tickets[client_id]


def get_user_ticket_for_robot():
    tvm_client = get_tvm_client()
    user_ticket = tvm_client.get_user_ticket(
        user_ip='127.0.0.1',
        server_host='vconf.yandex-team.ru',
        oauth_token=settings.VCONF_ROBOT_TOKEN,
    )
    return user_ticket
