from django.db import models


class GlobalPermission(models.Model):
    """
    Фейковая модель, чтобы иметь возможность создавать глобальные permissions,
    не привязанные к какой-то конкретной модели

    https://stackoverflow.com/a/37988537
    """
    class Meta:
        managed = False
        permissions = (
            ('admin_perm', 'Admin'),
            ('stream_viewer_perm', 'Stream viewer'),
        )
