from django.contrib import admin
from intranet.vconf.src.rooms.models import Room, Event


class RoomAdmin(admin.ModelAdmin):
    list_display = ('name', 'codec_ip')
    readonly_fields = ('event',)
    fields = (
        'event',
        'name',
        'room_id',
        'email',
        'office_id',
        'codec_ip',
        'timezone',
        'language',
    )
    search_fields = ('name', 'email',)


admin.site.register(Room, RoomAdmin)
admin.site.register(Event)
