import os
import logging

from django.core.management.base import BaseCommand

from intranet.vconf.src import settings

from intranet.vconf.src.rooms.manager import RoomManager
from intranet.vconf.src.rooms.management.commands.sync_codec_ips import Command as SyncCodecIpsCommand
from intranet.vconf.src.rooms.models import Room

log = logging.getLogger(__name__)


class Command(BaseCommand):
    def handle(self, *args, **options):

        # сначала обновляются ip кодеков из CUCM
        try:
            SyncCodecIpsCommand().handle()
        except Exception:
            log.exception('Failed to sync codec ips')

        domain = os.getenv("CODEC_WEBHOOK_DOMAIN")
        token = settings.CODEC_WEBHOOK_TOKEN
        url = f'{domain}/?token={token}'
        expressions = [
            '/Event/UserInterface/Extensions/Widget/Action',
            '/Event/UserInterface/Extensions/Panel/Clicked',
        ]
        if token is None:
            log.error('There is no variable CODEC_WEBHOOK_TOKEN')
            return
        if domain is None:
            log.error('There is no variable CODEC_WEBHOOK_DOMAIN')
            return
        codecs = (
            Room.objects
            .all()
            .values_list('codec_ip', flat=True)
        )
        for codec_ip in codecs:
            add_hook(codec_ip, url, expressions)
        log.info('All codecs have been processed')


def add_hook(codec_ip, url, expressions):
    manager = RoomManager(codec_ip)
    try:
        manager.register_webhook(url, expressions)
    except RoomManager.Error:
        log.error('Error when adding hook for {}'.format(codec_ip))
    else:
        log.info('Added hook for {}'.format(codec_ip))
