from datetime import datetime, timedelta
import logging

from django.core.management.base import BaseCommand

from intranet.vconf.src.rooms.models import Room
from intranet.vconf.src.rooms.manager import RoomManager

log = logging.getLogger(__name__)


class Command(BaseCommand):
    def handle(self, *args, **options):
        rooms_to_notify_codec_ips = get_rooms_to_notify_codec_ips()
        send_alerts_to_codecs(rooms_to_notify_codec_ips)


def get_rooms_to_notify_codec_ips() -> list[str]:
    now = datetime.now()
    # обновление кодеков происхоит раз в минуту, уведомление получат в
    # переговорках, где до конца встречи осталось от 5 до 6 минут
    room_ips = list(
        Room.objects
        .filter(
            event__end_time__gte=now + timedelta(0, 300),
            event__end_time__lt=now + timedelta(0, 360),
        )
        .values_list('codec_ip', flat=True)
    )
    return room_ips


def send_alerts_to_codecs(codec_ips: list[str]):
    for codec_ip in codec_ips:
        try:
            mngr = RoomManager(codec_ip)
            mngr.notify_meeting_ends()
        except RoomManager.Error:
            log.error('Can not send notification to codec with ip "%s"', codec_ip)
