# Generated by Django 2.1.2 on 2018-10-17 12:32

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('event_id', models.CharField(max_length=32, unique=True)),
                ('start_time', models.DateTimeField()),
                ('end_time', models.DateTimeField()),
                ('organizer', models.CharField(max_length=32)),
                ('call_id', models.CharField(blank=True, default=None, max_length=64, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Room',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('room_id', models.CharField(max_length=32, unique=True)),
                ('email', models.CharField(max_length=128, unique=True)),
                ('office_id', models.CharField(max_length=32)),
                ('codec_ipv4', models.CharField(max_length=128, unique=True)),
                ('codec_ip', models.CharField(max_length=128, unique=True)),
                ('codec_credentials', models.CharField(max_length=128)),
                ('timezone', models.CharField(max_length=64)),
                ('language', models.CharField(default='ru', max_length=32)),
                ('event', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='rooms.Event')),
            ],
        ),
        migrations.CreateModel(
            name='UpdateQueue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('datetime', models.DateTimeField()),
                ('room', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='rooms.Room')),
            ],
        ),
    ]
