from django.db import models


class Room(models.Model):
    event = models.ForeignKey(
        to='Event',
        blank=True,
        null=True,
        on_delete=models.SET_NULL,
    )
    name = models.CharField(
        max_length=128,
    )
    room_id = models.CharField(
        max_length=32,
        unique=True,
    )
    email = models.CharField(
        max_length=128,
        unique=True,
    )
    office_id = models.CharField(
        max_length=32,
    )
    codec_ip = models.CharField(
        max_length=128,
        unique=True,
        null=True,
    )
    timezone = models.CharField(
        max_length=64,
    )
    language = models.CharField(
        max_length=32,
        default='ru',
    )


class Event(models.Model):
    name = models.CharField(
        max_length=128,
    )
    event_id = models.CharField(
        max_length=32,
        unique=True
    )
    start_time = models.DateTimeField()
    end_time = models.DateTimeField()
    organizer = models.CharField(
        max_length=256,
    )
    call_id = models.CharField(
        max_length=64,
        blank=True,
        null=True,
        default=None,
    )


class UpdateQueue(models.Model):
    room = models.ForeignKey(
        to='Room',
        on_delete=models.CASCADE,
    )
    datetime = models.DateTimeField()
