import os
import socket
from typing import Optional

from django.core.handlers.wsgi import WSGIRequest


def room_in_beta_test_list(list_var_name: str, room_id: str) -> bool:
    """
    Есть ли id переговорки в списке тестовых переговорок в переменной
    окружения `id_list_name`

    :param list_var_name: название переменной окружения, в которой список
     id переговорок со Стаффа через запятую. Если такой переменной нет,
     то для любого id возвращает True
    :param room_id: id переговорки
    """
    room_list = os.getenv(list_var_name)
    if room_list is None:
        return True
    return room_id in room_list.split(',')


def is_ipv6_address(address: str) -> bool:
    try:
        socket.inet_pton(socket.AF_INET6, address)
    except socket.error:
        return False

    return True


def get_request_ipv6(request: WSGIRequest) -> Optional[str]:
    ip = request.META['HTTP_X_FORWARDED_FOR']
    if isinstance(request.META['HTTP_X_FORWARDED_FOR'], list):
        ip = ip[0]

    if is_ipv6_address(ip):
        return ip
    else:
        return None
