import os
import sys
import yenv

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

SECRET_KEY = os.getenv('DJANGO_SECRET_KEY', '123')
CDR_TOKEN = os.getenv('CDR_TOKEN', '123')
CODEC_WEBHOOK_TOKEN = os.getenv('CODEC_WEBHOOK_TOKEN', '123')
XIVA_SEND_TOKEN = os.getenv('XIVA_SEND_TOKEN')
XIVA_LISTEN_TOKEN = os.getenv('XIVA_LISTEN_TOKEN')
XIVA_URL = 'https://push.yandex-team.ru/v2/'
COUNT_STREAM_VIEWERS = os.getenv('COUNT_STREAM_VIEWERS')

if yenv.type == 'production':
    DEBUG = False
    STAFF_HOST = 'staff.yandex-team.ru'
    STAFF_API_HOST = 'staff-api.yandex-team.ru'
    AUTH_CHECKER_HOST = 'auth-checker.tools.yandex-team.ru'
else:
    DEBUG = bool(int(os.getenv('DJANGO_DEBUG', 1)))
    STAFF_HOST = 'staff.test.yandex-team.ru'
    STAFF_API_HOST = 'staff-api.test.yandex-team.ru'
    AUTH_CHECKER_HOST = 'auth-checker.test.tools.yandex-team.ru'

if yenv.type == 'production':
    CALENDAR_API_HOST = 'https://calendar-api.tools.yandex.net/internal'
else:
    CALENDAR_API_HOST = 'https://calendar-api.testing.yandex-team.ru/internal'

STAFF_URL = 'https://{host}'.format(host=STAFF_HOST)
STAFF_API_URL = 'https://{host}/v3'.format(host=STAFF_API_HOST)
AUTH_CHECKER_URL = 'https://{host}/'.format(host=AUTH_CHECKER_HOST)

ALLOWED_HOSTS = [
    '.yandex-team.ru',
    '.yandex.net',
    '.yandex.ru',
    '127.0.0.1',
]

# Application definition
AUTH_USER_MODEL = 'users.User'

INSTALLED_APPS = [
    'django_yauth',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django_idm_api',
    'intranet.vconf.src.call',
    'intranet.vconf.src.permissions',
    'intranet.vconf.src.rooms',
    'intranet.vconf.src.users',
    'intranet.vconf.src.cdr',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    # 'django.middleware.csrf.CsrfViewMiddleware',
    'intranet.vconf.src.lib.middleware.AuthMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    # 'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

TEMPLATES = [
    {
        'BACKEND': 'library.python.django.template.backends.arcadia.ArcadiaTemplates',
        'DIRS': ['intranet.vconf.src.rooms.templates'],
        'OPTIONS': {
            'debug': False,
            'context_processors': [
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
            'loaders': [
                'library.python.django.template.loaders.resource.Loader',
                'library.python.django.template.loaders.app_resource.Loader',
            ],
        },
    },
]

STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    'library.python.django.contrib.staticfiles.finders.ArcadiaAppFinder'
]

FORM_RENDERER = 'library.python.django.template.backends.forms_renderer.ArcadiaRenderer'
LOCALE_PATHS = ['intranet.vconf.src.rooms.locale']
STATIC_URL = '/admin/static/'
STATIC_ROOT = '/staticfiles'
ROOT_URLCONF = 'intranet.vconf.src.urls'

WSGI_APPLICATION = 'intranet.vconf.src.wsgi.application'


if yenv.type != 'development':
    DATABASES = {
        'default': {
            'ENGINE': 'django.db.backends.postgresql',
            'HOST': os.getenv(
                'DB_HOSTS',
                ','.join([
                    'myt-0gqg1r33dn2d6dnl.db.yandex.net',
                    'sas-97e9vz38svls51n8.db.yandex.net',
                    'vla-kvc2nxr07f4wl3p1.db.yandex.net',
                ])
            ),
            'PORT': 6432,
            'USER': 'vconf',
            'PASSWORD': os.getenv('DB_PASS', ''),
            'NAME': os.getenv('DB_NAME', ''),
            'CONN_MAX_AGE': 600,
            'DISABLE_SERVER_SIDE_CURSORS': True,
            'OPTIONS': {
                'sslmode': 'verify-full',
                'sslrootcert': '/etc/allCAs.pem',
                'connect_timeout': 2,
                'target_session_attrs': 'read-write',
            },
        }
    }
else:
    DATABASES = {
        'default': {
            'ENGINE': 'django.db.backends.postgresql',
            'HOST': 'localhost',
            'NAME': os.environ.get('PG_LOCAL_DATABASE', ''),
            'USER': os.environ.get('PG_LOCAL_USER', ''),
            'PASSWORD': os.environ.get('PG_LOCAL_PASSWORD', ''),
            'PORT': os.environ.get('PG_LOCAL_PORT', ''),
            # 'CONN_MAX_AGE': 600,
            # 'DISABLE_SERVER_SIDE_CURSORS': True,
            # 'OPTIONS': {
            #     'connect_timeout': 2,
            # },
        },
    }

LANGUAGE_CODE = 'en-us'
TIME_ZONE = 'UTC'
USE_I18N = True
USE_L10N = True
USE_TZ = True


from django.conf.locale.en import formats as en_formats
en_formats.DATETIME_FORMAT = "d M Y H:i:s"


LOGGING = {
    'version': 1,
    'disable_existing_loggers': True,
    'formatters': {
        'file': {'()': 'ylog.FileFormatter'},
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
    },
    'handlers': {
        'stream': {
            'class': 'logging.StreamHandler',
            'formatter': 'json',
            'stream': sys.stdout,
        },
        'errorbooster': {
            'class': 'intranet.vconf.src.lib.errorbooster.ErrorBoosterHandler',
        },
    },
    'loggers': {
        'vconf': {
            'handlers': ['stream', 'errorbooster'],
            'level': os.getenv('VCONF_LOG_LEVEL', 'DEBUG'),
            'propagate': False,
        },
        'django': {
            'handlers': ['stream', 'errorbooster'],
            'level': os.getenv('DJANGO_LOG_LEVEL', 'INFO'),
            'propagate': False,
        },
    },
    'root': {
        'level': 'INFO',
        'handlers': ['stream', 'errorbooster'],
    },
}

DISABLED_HOSTS = os.getenv('DISABLED_HOSTS', '').split(',')
ADMINS = os.getenv('ADMINS', '').split(',')
ADMINS_GROUPS = os.getenv('ADMINS', 'yandex_mnt_infra_itoffice,yandex_mnt_noc_office').split(',')


# YAUTH
from django_yauth.settings import *  # noqa
from blackbox import FIELD_LOGIN, FIELD_LANGUAGE


SILENCED_SYSTEM_CHECKS = [
    # https://docs.djangoproject.com/en/2.2/ref/checks/#adminsite
    # Проверка на то, что при использовании админки
    # включена миддлварина с аутентификацией
    # – нам она не нужна, у нас своя в django_yauth
    'admin.E408',
]
YAUTH_TYPE = 'intranet'
YAUTH_MECHANISMS = [
    'django_yauth.authentication_mechanisms.tvm',
    'django_yauth.authentication_mechanisms.oauth',
    'django_yauth.authentication_mechanisms.cookie',
]
YAUTH_USE_SITES = False

YAUTH_PASSPORT_FIELDS = [FIELD_LOGIN, FIELD_LANGUAGE]
YAUTH_IGNORE_PATHS = (
    r'^/api/save_rec',
    r'^/monitoring',
    r'^/frontapi/events/\d+/invite'
)

# TVM2
YAUTH_USE_TVM2_FOR_BLACKBOX = True
YAUTH_TVM2_GET_USER_INFO = True
YAUTH_TVM2_GET_USER_TICKET = True

TVM_SECRET = os.getenv('TVM_SECRET')
if yenv.type == 'production':
    TVM_CLIENT_ID = 2001576
    TVM_CALENDAR_CLIENT_ID = 2011072
    TVM_MESSENGER_CLIENT_ID = 2000482
else:
    TVM_CLIENT_ID = 2015323
    TVM_CALENDAR_CLIENT_ID = 2011068
    TVM_MESSENGER_CLIENT_ID = 2001664

YAUTH_TVM2_CLIENT_ID = TVM_CLIENT_ID
YAUTH_TVM2_SECRET = TVM_SECRET

VCONF_ROBOT_LOGIN = 'robot-vconf'
VCONF_ROBOT_UID = '1120000000092114'
# TODO: Переименовать переменную окружения STAFF_TOKEN в VCONF_ROBOT_TOKEN, а PLAYER_TOKEN удалить
VCONF_ROBOT_TOKEN = os.getenv('STAFF_TOKEN', '')
VCONF_ROBOT_PASSWORD = os.getenv('VCONF_ROBOT_PASSWORD', '')

YT_TOKEN = os.getenv('VCONF_ROBOT_YT_OAUTH_TOKEN')
YLOCK = {
    'backend': 'yt',
    'prefix': '//home/vconf/{}'.format(os.environ.get('YENV_TYPE')),
    'token': YT_TOKEN,
}

# IDM
from django_idm_api.settings import *  # noqa

IDM_URL_PREFIX = 'idm/'
IDM_API_TVM_SETTINGS = {
    'client_id': TVM_CLIENT_ID,
    'secret': TVM_SECRET,
}
IDM_TVM_CLIENT_ID = 2001600  # Перезаписываем client_id, потому что везде ходим в прод

YAUTH_TVM2_ALLOWED_CLIENT_IDS = [
    IDM_TVM_CLIENT_ID,
    TVM_MESSENGER_CLIENT_ID,
    TVM_CALENDAR_CLIENT_ID,
]


# Messenger
if yenv.type == 'production':
    YA_TEAM_ORG_ID = 34
    MESSENGER_API_HOST = 'messenger-internal.yandex.net'
else:
    YA_TEAM_ORG_ID = 34  # alpha: 34, testing: 5
    MESSENGER_API_HOST = 'messenger-internal.alpha.yandex.net'
    # MESSENGER_API_HOST = 'api.messenger.test.yandex.ru'

MESSENGER_API_URL = 'https://{host}/meta_api/'.format(host=MESSENGER_API_HOST)
MESSENGER_API_TIMEOUT = 2
MESSENGER_NAMESPACE_ID = 8
MESSENGER_HURAL_AVATAR_ID = '8a6e6460-0dc2-4313-831e-b720b5a37328'
MESSENGER_HURAL_AVATAR_KEY = '3928564/chat_avatar-%s' % MESSENGER_HURAL_AVATAR_ID

ZOOM_URL = 'https://yandex.zoom.us/j/'
CODEC_ZOOM_CALLS_ENABLED = os.getenv('CODEC_ZOOM_CALLS_ENABLED', False)


def get_list_from_env(var_name: str, var_type: type = str):
    value = os.getenv(var_name)
    if value:
        return [var_type(room_id) for room_id in value.split(',')]
    else:
        return []


PRODUCTION_BLACKLIST_CODEC_ROOM_IDS = get_list_from_env('PRODUCTION_BLACKLIST_CODEC_ROOM_IDS', int)
PRODUCTION_ALLOWED_OFFICE_IDS = get_list_from_env('PRODUCTION_ALLOWED_OFFICE_IDS', int)
TESTING_CODECS_ROOM_IDS = get_list_from_env('TESTING_CODECS_ROOM_IDS', int)
UNSUPPORTED_CODEC_MODEL_IDS = get_list_from_env('UNSUPPORTED_CODEC_MODELS', int)

CUCM_SERVICES_CONFIG = {
    'RIS': {
        'bind': '{http://schemas.cisco.com/ast/soap}RisBinding',
        'url': 'https://cipt-cucm1.yndx.net:8443/realtimeservice2/services/RISService70',
        'wsdl': 'https://cipt-cucm1.yndx.net:8443/realtimeservice2/services/RISService70?wsdl',
    },
}

CUCM_USERNAME = os.getenv('CUCM_USERNAME', '')
CUCM_PASSWORD = os.getenv('CUCM_PASSWORD', '')


if yenv.type == 'production':
    HURAL_TEMPLATE_ID = 85
else:
    HURAL_TEMPLATE_ID = 585

if yenv.type == 'production':
    CMS_HOST_TEMPLATE = os.getenv('CMS_HOST_TEMPLATE', 'cipt-cms{num}.yndx.net:8443')
else:
    CMS_HOST_TEMPLATE = os.getenv('CMS_HOST_TEMPLATE', 'cipt-cms-test{num}.yndx.net:8443')
CMS_API_URL_TEMPLATE = 'https://{host}/api/v1/'.format(host=CMS_HOST_TEMPLATE)

if yenv.type == 'production':
    CMS_CONFIG = {
        'auth_hash': os.getenv('CMS_AUTH_HASH', ''),
        'callProfiles': {
            'live': '4742bbd7-fad6-435f-ab82-69fe2b537da7',
            'rec': '0f89e953-ab23-4481-a6b3-8ed9aa7ac342',
            'liverec': '89993e42-8d68-4735-9d0e-b7ae0d3bed50',
        },
        'callLegProfiles': {
            'vconf': '32e3a55d-ed69-46f2-8124-f5e967170a91',
        },
        'streaming_url': 'rtmp://cms-streamer.yandex.net:1935',
        'storage': {
            1: 'https://cipt-cms-storage1.yndx.net/recs/spaces',
            2: 'https://cipt-cms-storage2.yndx.net/recs/spaces',
        },
    }
else:
    CMS_CONFIG = {
        'auth_hash': os.getenv('CMS_AUTH_HASH', ''),
        'callProfiles': {
            'live': '759f1c39-3b00-4871-b6b2-2154f120f5e3',
            'rec': '083f7d6d-c3a7-455d-8390-26f63937cbcd',
            'liverec': '98eb8d3c-67c8-4f51-b133-36ce4c7d2c08',
        },
        'callLegProfiles': {
            'vconf': '71d5ca66-1d29-4187-a691-7f01caeece41',
        },
        'streaming_url': 'rtmp://cipt-cms-streamer-proxy-test.yndx.net:1935',
        'storage': {
            1: 'https://cipt-cms-storage-test.yndx.net/recs/spaces',
        },
    }


# https://wiki.yandex-team.ru/vconf/dev/cdr-ips/
CMS_IPS_v4 = [
    '213.180.215.141',
    '37.9.86.35',
    '37.9.96.200',
    '5.45.222.184',
    '213.180.215.132',
    '213.180.215.134',
    '37.140.181.177',
    '37.9.96.201',
    '93.158.156.242',
    '93.158.156.243',
    '93.158.156.244',
    '87.250.238.82',
    '37.9.96.203',
    '37.9.96.204',
    '93.158.156.245',
    '77.88.40.74',
    '141.8.182.221',
    '213.180.207.11',
    '213.180.215.133',
    '77.88.40.73',
    '77.88.40.70',
    '5.45.222.185',
    '5.45.222.242',
    '5.45.222.243',
]

CMS_IPS_v6 = [
    '2a02:6b8:b010:902d::19',
    '2a02:6b8:0:515::a',
    '2a02:6b8:0:370e::4',
    '2a02:6b8:0:2b0d::6',
    '2a02:6b8:b010:902d::2c',
    '2a02:6b8:b010:902d::2d',
    '2a02:6b8:0:1a09::40',
    '2a02:6b8:0:370e::6',
    '2a02:6b8:b010:902d::2e',
    '2a02:6b8:b010:902d::2f',
    '2a02:6b8:b010:902d::30',
    '2a02:6b8:0:416::82',
    '2a02:6b8:0:370e::8',
    '2a02:6b8:0:370e::9',
    '2a02:6b8:b010:902d::bf',
    '2a02:6b8:0:1a09::53',
    '2a02:6b8:0:1a09::54',
    '2a02:6b8:0:1a09::3',
    '2a02:6b8:b010:902d::a9',
    '2a02:6b8:0:1a09::20',
    '2a02:6b8:0:1a09::c1',
    '2a02:6b8:0:2b0d::c1',
    '2a02:6b8:0:2b0d::8',
    '2a02:6b8:0:2b0d::9',
]

CMS_JIDS = [
    f'robot-cms-meeting{i:0>2}@cms.yandex-team.ru' if i < 37 else f'robot-cms-meeting{i:0>3}@cms.yandex-team.ru'
    for i in range(0, 251)
]

CMS_IPS = CMS_IPS_v4 + CMS_IPS_v6

# ErrorBooster

ERROR_BOOSTER_HOST = os.getenv('ERROR_BOOSTER_SYSLOG_HOST', '127.0.0.1')
ERROR_BOOSTER_PORT = int(os.getenv('ERROR_BOOSTER_SYSLOG_PORT', 12521))
ERROR_BOOSTER_PROJECT = os.getenv('DEPLOY_STAGE_ID')

EMAIL_HOST = 'outbound-relay.yandex.net'
EMAIL_TEXT = """
Вас пригласили на видео-встречу.

Чтобы принять в ней участие, пройдите, пожалуйста, по ссылке:
{link}

После открытия этой ссылки в браузере может понадобится дать разрешение на доступ к камере и микрофону.
Обратите внимание: поддерживаются только основанные на Chromium браузеры, например Yandex Browser или Opera.
Вы можете переслать это письмо или саму ссылку другим участникам, и они смогут присоединиться ко встрече.


-------------

You have been invited to join conference call.

To join, please follow the link:
{link}

When you open link in browser you may be asked to allow access to camera and microphone.
Please note: only Chromium–based browsers are supported (Yandex Browser or Opera, for example).
You can forward this email or link to a conference to other participants and they can join as well.
"""
