from django.urls import path, include
from django.contrib import admin

from intranet.vconf.src.rooms.views import webhook as codec_webhook

urlpatterns = [
    path('frontapi/', include(('intranet.vconf.src.call.urls.frontapi', 'call'), namespace='frontapi')),
    path('api/', include(('intranet.vconf.src.call.urls.api', 'call'), namespace='api')),
    path('cdr/', include(('intranet.vconf.src.cdr.urls', 'cdr'))),
    path('monitoring/', include(('intranet.vconf.src.call.urls.monitoring', 'call'), namespace='monitoring')),
    path('idm/', include(('django_idm_api.urls', 'django_idm_api'))),
    path('admin/', admin.site.urls),

    path('codec/webhook/', codec_webhook),
]

handler404 = 'intranet.vconf.src.call.views.errors.handler404'
handler500 = 'intranet.vconf.src.call.views.errors.handler500'
