PY3TEST()

OWNER(g:tools-vconf)

INCLUDE(${ARCADIA_ROOT}/antiadblock/postgres_local/recipe/recipe.inc)
DEPENDS(
  antiadblock/postgres_local/recipe
)

ENV(PYTEST_ADDOPTS=-l --nomigrations -v --create-db)
ENV(DJANGO_SETTINGS_MODULE=intranet.vconf.src.test_settings)
ENV(YENV_TYPE=development)
ENV(YENV_NAME=intranet)

DATA(
    arcadia/intranet/vconf/tests/cdr/messages/call_leg_end_call_end
    arcadia/intranet/vconf/tests/cdr/messages/call_leg_update
    arcadia/intranet/vconf/tests/cdr/messages/call_start_call_leg_update
    arcadia/intranet/vconf/tests/cdr/messages/cms_call_leg_start
    arcadia/intranet/vconf/tests/cdr/messages/sip_call_leg_start
)

PEERDIR(
    intranet/vconf/src
    intranet/vconf/src/call
    intranet/vconf/src/cdr
    intranet/vconf/src/ext_api
    intranet/vconf/src/lib
    intranet/vconf/src/permissions
    intranet/vconf/src/rooms
    intranet/vconf/src/users

    contrib/python/pytest-django
    contrib/python/factory-boy
)

PY_SRCS(
    __init__.py
    call/__init__.py
    call/factories.py
    call/mock.py
    lib/__init__.py
    lib/json_test.py
    lib/mocks.py
    lib/utils_test.py
    rooms/factories.py
)

TEST_SRCS(
    call/api_views_test.py
    call/call_manager_test.py
    call/call_views_test.py
    call/conftest.py
    call/ether_test.py
    call/event_test.py
    call/events_views_test.py
    call/hydrator_test.py
    call/participant_ctl_test.py
    call/template_manager_test.py
    call/templates_views_test.py
    call/test_call_data_merger.py
    call/test_node_status.py
    cdr/__init__.py
    cdr/conftest.py
    cdr/test_message_processing.py
    cdr/test_views.py
    conftest.py
    ext_api/__init__.py
    ext_api/test_calendar.py
    ext_api/test_cucm.py
    rooms/__init__.py
    rooms/conftest.py
    rooms/manager_test.py
    rooms/test_notify_ending_meetings.py
    rooms/test_update_codecs.py
    rooms/test_update_rooms.py
    rooms/views_test.py
    rooms/utils_test.py
    rooms/test_sync_codec_ips.py
)

SIZE(MEDIUM)

END()
