#!/bin/sh 

viewers_files="/etc/nginx/viewers-available/*"



check_real_server () {
    local _host _port
    _host=${1}
    _port=${2}

    if [ ! -z "${_port}" ]; then
        nc -zw 4 ${_host} ${_port} || echo "Error for ${_host} ${_port}"
    else 
        nc -zw 4 ${_host} 80 || nc -zw 4 ${_host} 443 || echo "Error for ${_host} (80/443)"
    fi
}
   
( awk '/proxy_pass http/ && ! /-upstream/ && ! /\$/ {if ($2 ~ "http://" && $2 !~ ":[0-9]+/?;") { gsub ("http://",""); gsub (";",""); gsub ("/.*", ""); print $2" 80"} else if ($2 ~ "https://" && $2 !~ ":[0-9]+/?;") { gsub ("https://",""); gsub (";",""); gsub ("/.*", ""); print $2" 443"} else if ($2 ~ ":[0-9]+") {gsub ("https?://", ""); gsub (":", " "); gsub ("/.*", ""); gsub (";", ""); print $2" "$3}} ' ${viewers_files}; awk '! /{/ && /^server / {gsub (":"," "); gsub (";",""); gsub (" backup", " "); print $2" "$3}' ${viewers_files}) | while read line; do
    check_real_server ${line}; 
done

