#!/bin/sh

viewers_available=/etc/nginx/viewers-available
viewers_enabled=/etc/nginx/viewers-enabled

log_error()
{
    printf '%b' "\033[1;31mERROR:\033[0m $@\n"
}

check_nginx_config()
{
    out="$(nginx -t 2>&1)"
    if [ $? -eq 0 ] ; then
        return 0
    fi

    conf=$(echo "$out" | egrep -o "${viewers_enabled}/[^: ]+" | head -1)
    if [ -z "${conf}" ] ; then
        # so we have another config file problem, skip executing
        echo "$out"
        return 1
    fi

    log_error "Viewer '$conf' has a problem, details:\n$out"
    unlink "${conf}"
    check_nginx_config

    return 0
}

# removing default config for nginx (it is not packaged)
rm 2>/dev/null /etc/nginx/sites-enabled/default || true

# generate viewers links
for viewer in ${viewers_available}/* ; do
    viewer_enable="${viewers_enabled}/$(basename ${viewer})"
    test -f ${viewer_enable} || ln -s "${viewer}" "${viewer_enable}"
done

# check viewers
check_nginx_config || exit 1

