location /authdir {
    internal;

    auth_request_set $YandexTeamLogin $upstream_http_X_Webauth_Login;

    # filled by envtpl in bin/viewer-set-webauth-location.sh
    proxy_pass https://webauth_upstream/auth_request?optional=token,cookies&idm_role=viewer/$production_host/user;
    proxy_pass_request_body off;
    proxy_set_header Host "{{VIEWER_WEBAUTH_HOST}}";
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto $scheme;
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header X-Retpath $http_host;
    proxy_set_header Content-Length "";
    proxy_connect_timeout 1s;
    proxy_send_timeout 600s;
    proxy_read_timeout 600s;
    proxy_next_upstream error timeout;
}
