map $geminiservice $geminiport {
    castor 21000;
    pollux 31000;
}

server {
    server_name gemini-cluster.viewer.*;
    include includes/server-section-with-acl;

    location ~^/gemini(?<geminihost>-(sas|myt|man)-[0-9]+)-(?<geminiservice>castor|pollux)$ {
        return 302 https://$http_host$uri/ ; }

    location ~^/gemini(?<geminihost>-(sas|myt|man)-[0-9]+)-(?<geminiservice>castor|pollux)/?(?<geminiurl>.*) {
        proxy_pass http://gemini$geminihost.search.yandex.net:$geminiport/$geminiurl?$args;
        include includes/location-section;
    }
    location =/ { return 301 https://viewer.yandex-team.ru/; }
}
