map $imagescm2service $imagescm2port {
    index             8103;
    mrdb              8113;
    taas-big          8123;
    test              8133;
    fast              8143;
    misc              8153;
    fast_test         8173;
    ultra             8183;
    ultra_test        8193;
    nightly           8223;
    branch_acceptance 8243;
    cvdup             9104;
    ultra_hahn        8203;
    ultra_banach      8213;
    ultra_acceptance  8233;
    mrdb_acceptance   8253;
    main_arnold       8263;
    mrdb_arnold       8513;
    micro_index       8273;
    ~(?<port>[0-9]+)  $port;
}

server {
    server_name images-cm2.viewer.*;

    include includes/server-section-with-acl;

    location =/ { return 302 https://$http_host/index/; }

    location ~/(main_acceptance)\/(?<imagescmurl>.*) {
         proxy_pass http://man1-7570.search.yandex.net:8133/$imagescmurl?$args;
         include includes/location-section;
    }

    location ~^/(?<imagescm2service>[\w-_]+)/(?<imagescmurl>.*) {
         proxy_pass http://tarski.search.yandex.net:$imagescm2port/$imagescmurl?$args;
         include includes/location-section;
    }
}
