map $kwservice $kwport {
    nest 8801;
    hen  8802;
    calc 8803;
    meta 8804;
    gene 8805;
    loader 8807;
    rich 8808;
    tracker 31430;
    default 8801;
}

server { 
    server_name kw.viewer.*;

    include includes/server-section-with-acl;

    location ~^/(?<kwhost>((((|att-|intra-|test-|sb-|stg-|pre-stg-)kiwi|ukrop|tukrop|oxygen|t-robot|acti)[0-9]+)|stg-kiwifresh|pre-stg-kiwifresh|ukrop-master))-(?<kwservice>nest|hen|calc|meta|gene|loader|rich|tracker)$ {
        return 302 https://$http_host$uri/ ; }

    location ~^/(?<kwhost>((((|att-|intra-|test-|sb-|stg-|pre-stg-)kiwi|ukrop|tukrop|oxygen|t-robot|acti)[0-9]+)|stg-kiwifresh|pre-stg-kiwifresh|ukrop-master))-(?<kwservice>nest|hen|calc|meta|gene|loader|rich|tracker)/?(?<kwurl>.*) {
        proxy_pass http://$kwhost.search.yandex.net:$kwport/$kwurl?$args;
        include includes/location-section;
    }

    location / { return 301 $http_referer$request_uri; }
    location =/ { return 200 "No such location here"; }

}
