upstream rotor-viewer-upstream {
server rotor-viewer.search.yandex.net:80;
}

map $rotorservice $rotorport {
    proxy 8802;
    http 8805;
    rotor 8808;
    scheduler 8809;
    cache 8817;
    executor 2003;
    registry 8810;
    balancer 8811;
}

server {
    server_name rotor.viewer.*;
    include includes/server-section-with-acl;

    location / {
         proxy_pass http://rotor-viewer-upstream;
         include includes/location-section;
    }

    location ~^/(?<rotorhost>((rhino|rotor-online-man-|rotor-online-sas-|rotor-sas-|rotor-cloud-myt-)\d+)|((sas1|man1)-\d+-\d+\.vm))/(?<rotorservice>\w+)$ {
        return 302 https://$http_host$uri/;
    }

    location ~^/(?<rotorhost>((rhino|rotor-online-man-|rotor-online-sas-|rotor-sas-|rotor-cloud-myt-)\d+)|((sas1|man1)-\d+-\d+\.vm))/(?<rotorservice>\w+)/(?<rotorurl>.*)$ {
        proxy_pass http://$rotorhost.search.yandex.net:$rotorport/$rotorurl?$args;
        include includes/location-section;
    }
}
