map $ukservice $ukport {
    nest 8801;
    hen 8802;
    calc 8803;
    meta 8804;
    gene 8805;
    tracker 31430;
    fresh 25701;
    coverage 25702;
    loader 8807;
    uzor 16892;
}

server { 
    server_name uk.v.*;
    include includes/server-section-with-acl;

    location /404.html { return 200 "You need to use URLs like: </br>
                         https://uk.v.yandex-team.ru/host/service </br>
                         <br>
                         Available services: nest, hen, calc, meta, gene, tracker, fresh, coverage, loader, uzor</br>
                         Available hosts: ukrop[000-9999], stg-ukrop[000-9999], pre-stg-ukrop[000-9999], tukrop[000-9999], ukrop-master</br>
                         &nbsp;&nbsp;&nbsp;&nbsp;.search.yandex.net domain will be added automatically, when proxying to backend.</br>
                         This not means, that all of this hosts online, but you can try. If host/service offline - you will get 502 error there.</br>
                         "; 
    }

    location / { 
        error_page 404 /404.html;
        return 404;
    }

    location ~ ^/(?<ukhost>((ukrop|stg-ukrop|pre-stg-ukrop|tukrop)[0-9]?[0-9][0-9][0-9])|ukrop-master)/(?<ukservice>(nest|hen|calc|meta|gene|tracker|fresh|coverage|loader|uzor))$ {
         return 301 https://$http_host/$ukhost/$ukservice/ ;
    }

    location ~ ^/(?<ukhost>((ukrop|stg-ukrop|pre-stg-ukrop|tukrop)[0-9]?[0-9][0-9][0-9])|ukrop-master)/(?<ukservice>(nest|hen|calc|meta|gene|tracker|fresh|coverage|loader|uzor))/(?<ukurl>.*) {
         proxy_pass http://$ukhost.search.yandex.net:$ukport/$ukurl?$args ;
         include includes/location-section;
    }
}

