map $xcbsservice $xcbsport {
    kwcalc 8803;
    kwmeta 8804;
    kwgene 8805;
    kwloader 8807;
    balancer 8000;
    default 8803;
}

server {
    server_name xcalc-bs.viewer.*;
    include includes/server-section-with-acl;

    location ~^/(?<xcbshost>[0-9a-z.-]+xcalc.vm)/(?<xcbsservice>kwcalc|kwmeta|kwgene|kwloader|balancer)$ {
        return 302 https://$http_host$uri/ ; }

    location ~^/(?<xcbshost>[0-9a-z.-]+xcalc.vm)/(?<xcbsservice>kwcalc|kwmeta|kwgene|kwloader|balancer)/?(?<xcbsurl>.*) {
         proxy_pass http://$xcbshost.vm.search.yandex.net:$xcbsport/$xcbsurl?$args;
         include includes/location-section;
    }
}
