map $zoraservice $zorabackendport {
    fetcher 32003;
    fetcher2 32027;
    pdfetch 31981;
    spider 8181;
    spider2 8182;
    zora 9998;
    xcalc 8001;
    bind 8088;
    kwmeta 8804;
    kwcalc 8803;
    kwgene 8805;
    kwloader 8807;
    balancer 8000;
    logicaldocs 9090;
    logsubs 8195;
    default 22;
}

map $zorahostname $zoradomain {
    "~dev-zora-[0-9]{2}" search.yandex.net;
    "~zora[0-9]-[0-9][0-9]" search.yandex.net;
    "~(dev-)?spider-(us|ru|tr|de)-(rt-)?[0-9][0-9]?[0-9]?" search.yandex.net;
    "~spider-[0-9][0-9]?[0-9]?-[0-9][0-9]?[0-9]?-[0-9][0-9]?[0-9]?-[0-9][0-9]?[0-9]?" search.yandex.net;
    default devnull;
}

server {
    server_name zora.viewer.*;

    include includes/server-section-with-acl;

    location / {
        rewrite ^/([^?/.]+)(\?.*)?$ $scheme://$host/$1/$2 redirect;
        rewrite ^/([^?]+/[^?/.]+)(\?.*)?$ $scheme://$host/$1/$2 redirect;
        return 404;
    }

    location ~^/(?<zorahostname>dev-zora-[0-9][0-9]|zora[0-9]-[0-9][0-9]|spider-[0-9][0-9]?[0-9]?-[0-9][0-9]?[0-9]?-[0-9][0-9]?[0-9]?-[0-9][0-9]?[0-9]?|(dev-)?spider-(us|ru|tr|de)-(rt-)?[0-9][0-9]?[0-9]?)\/(?<zoraservice>fetcher|fetcher2|pdfetch|spider|spider2|zora|xcalc|bind|kwmeta|kwcalc|kwgene|kwloader|balancer|logicaldocs|logsubs)\/(?<zoraurl>.*) {
        proxy_pass http://$zorahostname.$zoradomain:$zorabackendport/$zoraurl?$args;
        include includes/location-section;
    }

}

