#!/bin/bash

# basic vars:
# ~ not works there
IDMAPI="https://idm-api.yandex-team.ru/api/v1"
IDMGETROLESAPI="https://idm-api.yandex-team.ru/api/v1/roles"

BASE=${BASH_SOURCE%/*}

. ${BASE}/../.env

CURL="curl -s"

# include parser
. ${BASE}/shflags

DEFINE_string 'host' 'null' 'hostname to be added. Only short name, see below for domain zone (-z option)' 'n'
DEFINE_string 'resps' 'null' 'resps for this host. Should be like user1,user2,user3,etc (comma-separated list of resp logins or staff-groups)' 'r'
DEFINE_string 'zone' 'v' 'Domain zone for viewers (v or viewer)' 'z'

# parse the command-line
FLAGS "$@" || exit 1
eval set -- "${FLAGS_ARGV}"

VIEWER_HOST="${FLAGS_host}.${FLAGS_zone}.yandex-team.ru"
VIEWER_RESPS="$(echo ${FLAGS_resps} | sed 's/,/ /g')"

is_slug_exist() {
    # returns exit 1, if viewer exists; exit 0 if not exists
    local _slug="${1}"
    if [[ $(${CURL} -o /dev/null -w %{http_code} -H "Authorization: OAuth ${VIEWER_OAUTH_TOKEN}" ${IDMAPI}/rolenodes/viewer/viewers/${_slug}) == "404" ]] ; then
	return 1
    else
	return 0
    fi
}

add_slug() {
    # adds slug. Params (for JSON):
    # $1 = parent slug
    # $2 = new slug
    # #3 = slug name (human readable)
    local _parent _slug _slug_name
    if [ -z "${1}" -o -z "${2}" -o -z "${3}" ]; then
	echo "fail at add_slug"
	return 1
    else
	_parent="${1}"
	_slug="${2}"
	_slug_name="${3}"
        ${CURL} -so /dev/null -H "Content-Type: application/json" -H "Authorization: OAuth ${VIEWER_OAUTH_TOKEN}" ${IDMAPI}/rolenodes/ -d "{\"system\":\"viewer\", \"parent\":\"${_parent}\", \"slug\":\"${_slug}\",\"name\": \"${_slug_name}\", \"visibility\": true }"
    fi
}

grant_resp() {
    # grants resp logins for viewer their rights
    # $1 = login name
    # $2 = viewer name (fqdn)
    local _login _viewer
    if [ -z "${1}" -o -z "${2}" ]; then
	echo "Failed at grant_resp"
	return 1
    else
	_login="${1}"
	_viewer="${2}"
	${CURL} -so /dev/null -H "Content-Type: application/json" -H "Authorization: OAuth ${VIEWER_OAUTH_TOKEN}" ${IDMAPI}/rolerequests/ -d "{\"user\": \"${_login}\", \"path\": \"/${_viewer}/responsible/\", \"system\": \"viewer\"}"
	${CURL} -so /dev/null -H "Content-Type: application/json" -H "Authorization: OAuth ${VIEWER_OAUTH_TOKEN}" ${IDMAPI}/rolerequests/ -d "{\"user\": \"${_login}\", \"path\": \"/${_viewer}/user/\", \"system\": \"viewer\"}"
    fi
}

echo_fail() {
    echo "Seems, that something failed"
    echo "Run |$0 -z ${FLAGS_zone} -n ${FLAGS_host} -r ${FLAGS_resps} | again"
    return 1
}

check_resp() {
    # checks, that responsible login ($1) have correct grants to viewer ($2)
    # it is final check after script ran
    local _login _viewer
    if [ -z "${1}" -o -z "${2}" ]; then
	echo "Failed at grant_resp"
	return 1
    else
	_login="${1}"
	_viewer="${2}"
        ${CURL} -H "Content-Type: application/json" -H "Authorization: OAuth ${VIEWER_OAUTH_TOKEN}" "${IDMGETROLESAPI}/?system=viewer&path=/${_viewer}/user/" | grep -qi "${_login}" || echo_fail
	${CURL} -H "Content-Type: application/json" -H "Authorization: OAuth ${VIEWER_OAUTH_TOKEN}" "${IDMGETROLESAPI}/?system=viewer&path=/${_viewer}/responsible/" | grep -qi "${_login}" || echo_fail
    fi
}

is_slug_exist ${VIEWER_HOST}/ || add_slug "/viewers/" "${VIEWER_HOST}" "${VIEWER_HOST}"
is_slug_exist ${VIEWER_HOST}/role/ || add_slug "/viewers/${VIEWER_HOST}/" "role" "role"
is_slug_exist ${VIEWER_HOST}/role/responsible/ || add_slug "/viewers/${VIEWER_HOST}/role/" "responsible" "Ответственный"
is_slug_exist ${VIEWER_HOST}/role/user/ || add_slug "/viewers/${VIEWER_HOST}/role/" "user" "Пользователь"

for resp_login in ${VIEWER_RESPS}; do
    grant_resp ${resp_login} ${VIEWER_HOST};
done

for resp_login in ${VIEWER_RESPS}; do
    check_resp ${resp_login} ${VIEWER_HOST} && echo "OK for ${resp_login}@${VIEWER_HOST}" || echo "fail for ${resp_login}@${VIEWER_HOST}";
done
