#!/bin/bash

soft_not_installed() {
    echo "libshflags|git|dch package is not installed there, giving up"
    exit 1
}

host_exists() {
    echo "This host probably already exists, i will not create it"
    exit 1
}

BASE=${BASH_SOURCE%/*}

# include parser
. ${BASE}/shflags

# define arguments
DEFINE_string 'host' 'null' 'hostname to be added. Only short name, see below for domain zone (-z option)' 'n'
DEFINE_string 'resps' 'null' 'resps for this host. Should be like user1,user2,user3,etc (comma-separated list of resp logins or staff-groups)' 'r'
DEFINE_string 'backends' 'null' 'backend(s) for this host' 'b'
DEFINE_string 'zone' 'v' 'Domain zone for viewers (v or viewer)' 'z'
DEFINE_string 'force' 'no' 'Use Jedi force?' 'f'
DEFINE_string 'release' 'no' 'Do we need to release now? Use text "package" to only release package or any another text to create viewer+release package' 'd'

# parse the command-line
FLAGS "$@" || exit 1
eval set -- "${FLAGS_ARGV}"

host=${FLAGS_host}
resps=${FLAGS_resps}
backends=${FLAGS_backends}
zone=${FLAGS_zone}
confdir="etc/nginx/viewers-available"


if [[ ${host} == 'null' ]] || [[ ${resps} == 'null' ]] || [[ ${backends} == 'null' ]] ; then
    echo "all params are have to be set: --host, --resps, --backends"
    exit 1
fi

if [[ ${zone} != 'v' ]] && [[ ${zone} != 'viewer' ]]; then
    echo "zone can be v or viewer only"
    exit 1
fi

/usr/bin/git pull
if [[ ${FLAGS_force} != 'jedi' ]] ; then
    test -s "${confdir}/${host}.v.yandex-team.ru" && host_exists
    test -s "${confdir}/${host}.viewer.yandex-team.ru" && host_exists
    if [[ $(curl -s https://golem.yandex-team.ru/api/get_host_resp.sbml?host=${host}.v.yandex-team.ru) != "" ]]; then host_exists; fi
    if [[ $(curl -s https://golem.yandex-team.ru/api/get_host_resp.sbml?host=${host}.viewer.yandex-team.ru) != "" ]]; then host_exists; fi
fi

prefix="${host}.${zone}"
domain="${prefix}.yandex-team.ru"

echo "Golem answer: "
curl "https://golem.yandex-team.ru/api/manage_host.sbml?action=create&hostname=${domain}&resps=${resps}"
echo

echo "upstream ${host}-${zone}-upstream {" > ${confdir}/${domain}
for i in $(echo $backends | sed 's/,/ /g'); do echo "server $i;" >> ${confdir}/${domain} ; done
echo "}" >> ${confdir}/${domain}

echo >> ${confdir}/${domain}

echo "server {
    server_name ${prefix}.*;

    include includes/server-section-with-acl;

    location / {
         proxy_pass http://${host}-${zone}-upstream;
         include includes/location-section;
    }
}" >> ${confdir}/${domain}

if [ "${FLAGS_release}" != "no" ]; then
    git add "${confdir}/${domain}"
    git commit -m "Host ${domain} with backends ${backends} and resps ${resps} added to $(basename ${confdir})/" "${confdir}/${domain}"

    releaser release
fi

${BASE}/add-idm.sh -z ${zone} -n ${host} -r ${resps}
